<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\PollingStation;
use App\Models\BlockCode;
use App\Models\BlogsData;
use App\Models\Ward;
use App\Models\AppUser;
use Illuminate\Support\Facades\DB; // Import the DB facade


class AdminDashboardController extends Controller
{
    public function __construct()
{
    $this->middleware('auth');  // Ensure user is logged in
    $this->middleware(function ($request, $next) {
        if (Auth::user()->role !== 'admin') {
            return redirect()->route('dashboard');
        }
        return $next($request);
    });
}
public function index()
{
    if (Gate::denies('isAdmin')) {
        abort(403, 'Unauthorized action.');
    }
    // Fetch total user count
    $totalUsers = User::count();
    $total_blogs=BlogsData::count();

    // Fetch users to display in the table
    $users = User::all();
    
    $blogs_data = BlogsData::all();

    return view('admin.dashboard', compact('totalUsers', 'users','blogs_data','users','total_blogs'));
}
public function voters()
{
    if (Gate::denies('isAdmin')) {
        abort(403, 'Unauthorized action.');
    }

    // Fetch total user count
     $totalUsers = User::count();
    $total_blogs=BlogsData::count();

    // Fetch users to display in the table
    $users = User::all();
    
    $blogs_data = BlogsData::with('user')->get();

    
 

    return view('admin.voters.all_voters_show',  compact('totalUsers', 'users','blogs_data','users','total_blogs'));
}
public function logout(Request $request)
{
    Auth::logout(); // Log out the authenticated admin

    // Redirect to the login page after logout
    return redirect()->route('login');
}
public function showCreateUserForm()
    {
        $pollingStations = PollingStation::all();
        $blockCodes = BlockCode::all();
        $wards = Ward::all();
        return view('admin.create-user',compact('pollingStations', 'blockCodes', 'wards'));
    }
public function showBlogForm()
    {
      
        return view('admin.voters.add_blog');
    }
 
    // Handle the form submission for creating a user
    public function createUser(Request $request)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
           
            'gender' => 'nullable',              // Validating new fields
           
            
        ]);

        // Create the user and store the additional fields in the database
        $user = User::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'password' => Hash::make($validated['password']),
             
            'gender' => $validated['gender'] ,      
            
            'role' => 'user',  // Assign the default 'user' role to new users        
        ]);

        return redirect()->route('admin.dashboard')->with('success', 'User created successfully!');
    }


    public function showEditUserForm(User $user)
    {
        return view('admin.edit-user', compact('user'));
    }

    public function updateUser(Request $request, User $user)
    {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users,email,' . $user->id, // Ensures email is unique except for the current user
            'password' => 'nullable|string|min:8|confirmed', // Password is optional for update
            'gender' => 'nullable',
           
            
        ]);

        // Update user fields
        $user->update([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'gender' => $validated['gender'],
              
            
        ]);

        // If the password is provided, update it
        if ($request->filled('password')) {
            $user->password = Hash::make($validated['password']);
            $user->save();
        }

        return redirect()->route('admin.dashboard')->with('success', 'User updated successfully!');
    }
    
    public function edit($id)
{
    $voter = BlogsData::findOrFail($id);
    $pollingStations = PollingStation::all(); // Replace with your actual model and logic
    $blockCodes = BlockCode::all();
    $wards = Ward::all();
    
    return view('admin.voters.edit', compact('voter', 'pollingStations', 'blockCodes', 'wards'));
}
   public function update(Request $request, $id)
{
    // Validate input fields
    $request->validate([
        'title' => 'required',
        'content' => 'required',
        'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg|max:2048' // Image validation
    ]);

    // Find the voter record by id
    $voter = BlogsData::findOrFail($id);

    // If an image is uploaded, handle the image file
    if ($request->hasFile('image')) {
        // Delete the old image if it exists
        if ($voter->image && file_exists(public_path('storage/app/public/images/' . $voter->image))) {
            unlink(public_path('storage/images/' . $voter->image));
        }

        // Store the new image
        $imageName = time() . '.' . $request->image->extension();
        $request->image->storeAs('public/images', $imageName);

        // Update the voter with the new image path
        $voter->image = $imageName;
    }

    // Update other fields (title, content) without touching image
    $voter->title = $request->title;
    $voter->content = $request->content;

    // Save the updated record
    $voter->save();

    // Redirect with success message
    return redirect()->back()->with('success', 'Update successful!');
}

    
    public function show($id)
{
    $voter = BlogsData::with('user')->findOrFail($id); // Ensure it includes related user data if needed
    return view('admin.voters.voter_show', compact('voter'));
}
     public function destroy($id)
    {
        $voter = BlogsData::findOrFail($id);
        $voter->delete(); // Delete the voter entry

        return redirect()->back()->with('success','Voter entry deleted successfully.');
    }    
    
   public function manageUsers()
{
    $users = User::all(); // Fetch all users to display in the dropdown
    return view('admin.manage_users', compact('users'));
}

public function showVotersByUser($user_id)
{
    $voters = BlogsData::where('user_id', $user_id)->get(); // Get voters based on user_id
     $maleCount = BlogsData::where('user_id', $user_id)->where('gender', 'Male')->count();
    $femaleCount = BlogsData::where('user_id', $user_id)->where('gender', 'Female')->count();

   if ($voters->isEmpty()) {
        return response()->json("no_data"); // Return a custom "no data" response
    }

    // Return only the table HTML for AJAX response
    return view('admin.user_voters', compact('voters','maleCount', 'femaleCount'))->render(); 
}
    public function showVotersByBlock($block_code)
    {
    
    // Retrieve voters with the specified block code
    $voters = VotersData::where('block_code', $block_code)->get();
     $maleCount = VotersData::where('block_code', $block_code)->where('gender', 'Male')->count();
    $femaleCount = VotersData::where('block_code', $block_code)->where('gender', 'Female')->count();
    
    // Pass block code as well for reference
    return view('admin.block_code.voters_by_block', compact('voters', 'block_code', 'maleCount', 'femaleCount'));
}
    public function showDuplicateCnic()
{
     $duplicateCnics = DB::table('voters_data AS original')
            ->select(
                'original.id',
                'original.cnic AS original_cnic',
                DB::raw("REPLACE(original.cnic, ' ', '') AS clean_cnic"),
                'original.block_code' // Select the block_code column
            )
            ->join(DB::raw('(SELECT REPLACE(cnic, " ", "") AS clean_cnic FROM voters_data GROUP BY clean_cnic HAVING COUNT(*) > 1) AS duplicates'), 
                'duplicates.clean_cnic', '=', DB::raw("REPLACE(original.cnic, ' ', '')"))
            ->orderBy('clean_cnic')
            ->get();


    return view('admin.duplicate_cnic', compact('duplicateCnics'));
}

}
