<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('voter_records', function (Blueprint $table) {
            $table->id();
            $table->string('polling_station');
            $table->string('block_code');
            $table->string('ward_no');
            $table->string('gender');
            $table->string('gharana_number');
            $table->string('cnic')->unique();
            $table->string('father_name');
            $table->string('address');
            $table->integer('age');
            $table->string('name');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('voter_records');
    }
};
