<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Voter Details</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    
    <!-- Buttons extension CSS -->
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    
    <!-- jQuery, DataTables, and Buttons JS -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    
    <!-- JSZip and PDFMake for CSV and PDF support -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    
    <!-- Buttons for HTML5 export (CSV, PDF, Excel) -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    
    <!-- Button for Print -->
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

    <style>
        .container-fluid {
            padding: 20px;
        }
        .card {
            width: 100%;
        }
        .table-responsive {
            overflow-x: auto;
        }
    </style>
</head>
<body>
   <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.all.voters') }}">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="{{ route('userManagement') }}">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="{{ route('admin.manageUsers') }}">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.cnicWithSpaces') }}">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.duplicateCnic') }}">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="{{ route('admin.createUser') }}">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.polling_stations.index') }}">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.block_code.index') }}">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="{{ route('admin.ward.index') }}">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="{{ route('admin.logout') }}" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <div class="container-fluid">
        <div class="card">
            <div class="card-header">
                <h3>Voters in Block Code: {{ $block_code }}</h3>
                <p style="float:right"><strong>Male Count:</strong> {{ $maleCount }}  <strong>Female Count:</strong>  : {{ $femaleCount }}</p>
              
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table id="votersTable" class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Father's Name</th>
                                <th>CNIC</th>
                                <th>Polling Station</th>
                                <th>Ward No</th>
                                <th>Gender</th>
                                <th>Gharana Number</th>
                                <th>Address</th>
                                <th>Age</th>
                                <th>Silsila Number</th>
                                <th>Actions</th>
                                
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($voters as $voter)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $voter->name }}</td>
                                    <td>{{ $voter->father_name }}</td>
                                    <td>{{ $voter->cnic }}</td>
                                    <td>{{ $voter->polling_station }}</td>
                                    <td>{{ $voter->ward_no }}</td>
                                    <td>{{ $voter->gender }}</td>
                                    <td>{{ $voter->gharana_number }}</td>
                                    <td>{{ $voter->address }}</td>
                                    <td>{{ $voter->age }}</td>
                                    <td>{{ $voter->silsila_number }}</td>
                                     <td>
                                        <!-- View Button -->
                                        <a href="{{ route('admin.showVoter', $voter->id) }}" class="btn btn-info btn-sm">View</a>
                                        
                                        <!-- Edit Button -->
                                        <a href="{{ route('admin.editVoter', $voter->id) }}" class="btn btn-warning btn-sm">Edit</a>
                                        
                                        <!-- Delete Button -->
                                        <form action="{{ route('admin.deleteVoter', $voter->id) }}" method="POST" style="display:inline;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                                        </form>
                                    </td>
                                    
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="card-footer text-center">
                <a href="{{ route('admin.dashboard') }}" class="btn btn-secondary mt-3">Back to Block Codes</a>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
<!-- DataTables CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">

<!-- Buttons extension CSS -->
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">

<!-- jQuery, DataTables, and Buttons JS -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>

<!-- JSZip and PDFMake for CSV and PDF support -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

<!-- Buttons for HTML5 export (CSV, PDF, Excel) -->
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>

<!-- Button for Print -->
<script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>

   <script>
    $(document).ready(function() {
        $('#votersTable').DataTable({
            "paging": true,
            "ordering": true,
            "info": true,
            "searching": true,
            // dom: 'Bfrtip', // Add this to enable Buttons extension
            // buttons: [
            //     'csv', 'excel', 'pdf', 'print' // Enable different export buttons
            // ],
            // Show entries dropdown with options
           
        });
    });
</script>
</body>
</html>
