<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Dashboard Content -->
    <div class="container mt-5" style="max-width:1200px">
        <h3>Admin Dashboard</h3>

        <!-- Stats Section -->
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Total Users</h5>
                        <p class="card-text"><?php echo e($totalUsers); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Polling Stations</h5>
                    <p class="card-text"><?php echo e($totalPollingStations); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Wards</h5>
                    <p class="card-text"><?php echo e($totalWards); ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Block Codes</h5>
                    <p class="card-text"><?php echo e($totalBlockCodes); ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3" style="margin-top:10px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Voters Entries </h5>
                    <p class="card-text"><?php echo e($totalVoters); ?></p>
                </div>
            </div>
        </div>
        
        <div class="col-md-3" style="margin-top:10px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Males</h5>
                    <p class="card-text"><?php echo e($totalMales); ?></p>
                </div>
            </div>
        </div>

        <div class="col-md-3" style="margin-top:10px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Females</h5>
                    <p class="card-text"><?php echo e($totalFemales); ?></p>
                </div>
            </div>
        </div>
         <div class="col-md-3" style="margin-top:10px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Users Mobile App </h5>
                    <p class="card-text"><?php echo e($totalAppUsers); ?></p>
                </div>
            </div>
        </div>
         <div class="col-md-3" style="margin-top:10px;">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Mobile App Users Usage Count</h5>
                    <p class="card-text"><?php echo e($hitCount); ?></p>
                </div>
            </div>
        </div>
        </div>

    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Initialize DataTables -->
<script>
    $(document).ready(function() {
     
        $('#usersTable, #votersTable').DataTable({
            "paging": true,
            "ordering": true,
            "info": true,
            "searching": true
        });
    });
</script>
<script>
    $(document).ready(function() {
        
    });
</script>

</body>

</html>
<?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>