<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Welcome, <?php echo e(Auth::user()->name); ?>!</h3>
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary" style="float: right;">Dashboard</a>
                    </div>
                    <div class="card-body">
                        <!-- Show success message if it exists -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        
                        <!-- Button for adding new voter data -->
                        <a href="<?php echo e(route('user.dataForm')); ?>" class="btn btn-primary mt-3" style="float: right;">Add New Voter Data</a>   

                        <!-- Button to Open Modal for setting default fields -->
                        <button type="button" class="btn btn-warning mt-3" data-toggle="modal" data-target="#updateDefaultModal" style="float: right;">
                            Set Default Fields
                        </button>

                        <!-- Data Form -->
                        <h4>Submit Your Data</h4>
                        <form action="<?php echo e(route('user.store')); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <div class="form-group">
        <label for="name">Name</label>
        <input type="text" name="name" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="father_name">Father Name</label>
        <input type="text" name="father_name" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="address">Address</label>
        <input type="text" name="address" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="age">Age</label>
        <input type="number" name="age" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="gharana_number">Gharana Number</label>
        <input type="text" name="gharana_number" class="form-control" required>
    </div>
    <div class="form-group">
        <label for="cnic">CNIC</label>
        <input type="text" name="cnic" class="form-control" required>
    </div>

    <!-- Polling Station Dropdown (Preselected) -->
    <div class="form-group"  style="display: none;">
        <label for="polling_station">Polling Station</label>
        <select name="polling_station" class="form-control" required>
            <option value="">Select Polling Station</option>
            <?php $__currentLoopData = $pollingStations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($station->polling_station_name); ?>" 
                    <?php echo e(old('polling_station', $user->polling_station) == $station->polling_station_name ? 'selected' : ''); ?>>
                    <?php echo e($station->polling_station_name); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- Block Code Dropdown (Preselected) -->
    <div class="form-group" style="display: none;">
        <label for="block_code">Block Code</label>
        <select name="block_code" class="form-control" required>
            <option value="">Select Block Code</option>
            <?php $__currentLoopData = $blockCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($code->block_code); ?>" 
                    <?php echo e(old('block_code', $user->block_code) == $code->block_code ? 'selected' : ''); ?>>
                    <?php echo e($code->block_code); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- Ward No Dropdown (Preselected) -->
    <div class="form-group"  style="display: none;">
        <label for="ward_no">Ward No</label>
        <select name="ward_no" class="form-control" required>
            <option value="">Select Ward No</option>
            <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($ward->ward_number); ?>" 
                    <?php echo e(old('ward_no', $user->ward_no) == $ward->ward_number ? 'selected' : ''); ?>>
                    <?php echo e($ward->ward_number); ?>

                </option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

    <!-- Gender Dropdown (Preselected) -->
    <div class="form-group"  style="display: none;">
        <label for="gender">Gender</label>
        <select name="gender" class="form-control" required>
            <option value="Male" <?php echo e(old('gender', $user->gender) == 'Male' ? 'selected' : ''); ?>>Male</option>
            <option value="Female" <?php echo e(old('gender', $user->gender) == 'Female' ? 'selected' : ''); ?>>Female</option>
            <option value="Other" <?php echo e(old('gender', $user->gender) == 'Other' ? 'selected' : ''); ?>>Other</option>
        </select>
    </div>

    <!-- User ID (Hidden) -->
    <input type="hidden" name="user_id" value="<?php echo e(Auth::id()); ?>">

    <!-- Silsila Number (Visible) -->
    <div class="form-group">
        <label for="silsila_number">Silsila Number</label>
        <input type="text" name="silsila_number" class="form-control" required>
    </div>

    <button type="submit" class="btn btn-primary">Submit</button>
</form>

                        <!-- Logout Button -->
                        <div class="text-right mt-4">
                            <form action="<?php echo e(route('logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-danger">Logout</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Modal for setting default fields -->
    <div class="modal fade" id="updateDefaultModal" tabindex="-1" role="dialog" aria-labelledby="updateDefaultModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="updateDefaultModalLabel">Set Default Fields</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <form action="<?php echo e(route('user.updateDefault')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <div class="modal-body">
                        <!-- Polling Station Dropdown -->
                        <div class="form-group">
                            <label for="polling_station">Polling Station</label>
                            <select name="polling_station" class="form-control" required>
                                <option value="">Select Polling Station</option>
                                <?php $__currentLoopData = $pollingStations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($station->polling_station_name); ?>" 
                                        <?php echo e($user->polling_station == $station->polling_station_name ? 'selected' : ''); ?>>
                                        <?php echo e($station->polling_station_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Block Code Dropdown -->
                        <div class="form-group">
                            <label for="block_code">Block Code</label>
                            <select name="block_code" class="form-control" required>
                                <option value="">Select Block Code</option>
                                <?php $__currentLoopData = $blockCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $code): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($code->block_code); ?>" 
                                        <?php echo e($user->block_code == $code->block_code ? 'selected' : ''); ?>>
                                        <?php echo e($code->block_code); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Ward No Dropdown -->
                        <div class="form-group">
                            <label for="ward_no">Ward No</label>
                            <select name="ward_no" class="form-control" required>
                                <option value="">Select Ward No</option>
                                <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ward->ward_number); ?>" 
                                        <?php echo e($user->ward_no == $ward->ward_number ? 'selected' : ''); ?>>
                                        <?php echo e($ward->ward_number); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Gender Dropdown -->
                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select name="gender" class="form-control">
                                <option value="Male" <?php echo e($user->gender == 'Male' ? 'selected' : ''); ?>>Male</option>
                                <option value="Female" <?php echo e($user->gender == 'Female' ? 'selected' : ''); ?>>Female</option>
                                <option value="Other" <?php echo e($user->gender == 'Other' ? 'selected' : ''); ?>>Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                        <button type="submit" class="btn btn-primary">Save Changes</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
<?php /**PATH C:\laragon\www\electionManagemntSystem\resources\views/user/data-form.blade.php ENDPATH**/ ?>