<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
     <!-- Include CKEditor -->
    <script src="https://cdn.ckeditor.com/ckeditor5/29.1.0/classic/ckeditor.js"></script>
    
</head>
<body>
    <div class="fluid-container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-12">
                
                <div class="card">
                  
                    <div class="card-header">
                        <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary" style="float: right;">Dashboard</a>
                    </div>
                    <div class="card-body">
                        <!-- Show success message if it exists -->
                        <?php if(session('success')): ?>
                            <div class="alert alert-success">
                                <?php echo e(session('success')); ?>

                            </div>
                        <?php endif; ?>
                        
                        <!-- Button for adding new voter data -->
                        <a href="<?php echo e(route('user.dataForm')); ?>" class="btn btn-primary mt-3" style="float: right;">Add New Blog Data</a>   

                        <!-- Button to Open Modal for setting default fields -->
                        <!--<button type="button" class="btn btn-warning mt-3" data-toggle="modal" data-target="#updateDefaultModal" style="float: right;">-->
                        <!--    Set Default Fields-->
                        <!--</button>-->

                        <!-- Data Form -->
                        <h4>Submit Your Data</h4>
                        <form action="<?php echo e(route('user.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>

                         <!-- Silsila Number (Visible) -->
                         <div class="form-group">
                                <label for="silsila_number">Title</label>
                                <input type="text" name="title"  id= "title" class="form-control" required>
                        </div>
                         
                        <div class="form-group">
                            <label for="gharana_number">Content</label>
                          <textarea name="content" id="content" class="form-control" style="height: 200px;"></textarea>
                        </div>
                        
           

                        <!-- Image upload input -->
                        <div class="form-group">
                            <label for="image">Upload  Image</label>
                            <input type="file" class="form-control-file" id="image" name="image">
                        </div>
                       
                        
                

                            <!-- User ID (Hidden) -->
                            <input type="hidden" name="user_id" value="<?php echo e(Auth::id()); ?>">

                           

                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>

                        <!-- Logout Button -->
                        <div class="text-right mt-4">
                            <form action="<?php echo e(route('logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-danger">Logout</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

  
<script>
        // Initialize CKEditor
        ClassicEditor
            .create(document.querySelector('#content'))
            .then(editor => {
                window.editor = editor;  // Store editor instance for later use

                // Custom form validation
                editor.model.document.on('change:data', () => {
                    // Check if the editor content is empty and set the custom validity
                    document.getElementById('content').setCustomValidity(editor.getData().trim() === '' ? 'This field cannot be empty' : '');
                });
            })
            .catch(error => {
                console.error(error);
            });
    </script>
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
<?php /**PATH /home/couperbe/blog.couponcode24.com/resources/views/user/data-form.blade.php ENDPATH**/ ?>