<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Users</title>
    <link href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css" rel="stylesheet">
    <style>
        .container {
            margin-top: 20px;
        }
       
        .form-group select {
            width: 100%;
            height: 38px;
        }
        #loader {
            display: none;
            position: absolute;
            top: 50%;
            left: 50%;
            transform: translate(-50%, -50%);
            font-size: 2rem;
            color: #007bff;
        }
    </style>
</head>
<body>
    
   <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <div class="container">
         <h3>Manage Users</h3>
                 
        <div class="card">
            <div class="card-header">
               <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn btn-success" style="float:right">Back to Admin Dashboard</a>
            </div>
            <div class="card-body">
                <form id="userSelectionForm">
                    <div class="form-group">
                        <label for="userDropdown">Select User</label>
                        <select id="userDropdown" class="form-control">
                            <option value="">Select a user</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </form>
            </div>
        </div>

        <!-- Loader -->
        <div id="loader">
            <span>Loading...</span>
        </div>

       
        
    </div>
    <div class="container-fluid">
     <!-- Voter List Table -->
        <div id="voterList" class="mt-4">
            <!-- Voters will be loaded here dynamically -->
        </div>
        </div>

    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

   <script>
    // Listen for user selection
    $('#userDropdown').on('change', function() {
        var userId = $(this).val(); // Get selected user ID from dropdown
        if (userId) {
            // Show the loader
            $('#loader').show();

            // Fetch voters for selected user
            $.get(`admin/user/${userId}/voters`, function(data) {
                // Hide the loader after data is received
                $('#loader').hide();

                // If no data is returned, show the "No data available" message
                if (data === "no_data") {
                    $('#voterList').html('<p>No data available for the selected user.</p>');
                } else {
                    // Inject the returned data (table) into the #voterList div
                    $('#voterList').html(data);

                    // Apply DataTables to the table once data is loaded
                    $('#voterTable').DataTable();
                }
            }).fail(function() {
                // Hide the loader and show an error message
                $('#loader').hide();
                alert("Failed to load voter data.");
            });
        } else {
            $('#voterList').html(''); // Clear the list if no user is selected
        }
    });
</script>

</body>
</html>
<?php /**PATH /home/u204215099/domains/askforcoupons.com/public_html/blogsAdminDashboard/resources/views/admin/manage_users.blade.php ENDPATH**/ ?>