<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    <style>
    .container-fluid{
        padding:20px;
        
    }
        html, body {
            width: 100%;
            height: 100%;
        }

        .container {
            width: 100%;
            padding-left: 15px;
            padding-right: 15px;
        }
    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Dashboard Content -->
    <div class="container-fluid">
        <h3>Admin Dashboard</h3>
        <br>
        <div class="col-md-12" >
            <div class="card">
                <div class="card-header">
                    <h5>All Voters Entries</h5>
                </div>
                <div class="card-body">
                    <table id="votersTable" class="table table-striped table-responsive">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Silsila Number</th>
                                <th>Gharana Number</th>
                                <th>Name</th>
                                <th>Father's Name</th>
                                <th>CNIC</th>
                                <th>Age</th>
                                <th>Block Code</th>
                                <th>Ward No</th>
                                <th>Address</th>
                                <th>Gender</th>
                                <th>Entry Person</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $voters_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($record->silsila_number); ?></td>
                                    <td><?php echo e($record->gharana_number); ?></td>
                                    <td><?php echo e($record->name); ?></td>
                                    <td><?php echo e($record->father_name); ?></td>
                                    <td><?php echo e((strpos($record->cnic, '-') !== false || strpos($record->cnic, '–') !== false) ? str_replace(['-', '–'], '', $record->cnic) : $record->cnic); ?></td>
                                    <td><?php echo e($record->age); ?></td>
                                    <td><?php echo e($record->block_code); ?></td>
                                    <td><?php echo e($record->ward_no); ?></td>
                                    <td><?php echo e($record->address); ?></td>
                                    <td><?php echo e($record->gender); ?></td>
                                    <td><?php echo e($record->user->name); ?></td>
                                    <td>
                                        <a href="<?php echo e(route('admin.editVoter', $record->id)); ?>" class="btn btn-warning btn-sm">Edit</a>
                                        <a href="<?php echo e(route('admin.showVoter', $record->id)); ?>" class="btn btn-info btn-sm">View</a>
                                        <form action="<?php echo e(route('admin.deleteVoter', $record->id)); ?>" method="POST" style="display:inline;">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this record?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Initialize DataTables -->
    <script>
        $(document).ready(function() {
            $('#usersTable, #votersTable').DataTable({
                "paging": true,
                "ordering": true,
                "info": true,
                "searching": true
            });
        });
    </script>

</body>
</html>
<?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/voters/all_voters_show.blade.php ENDPATH**/ ?>