<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">

    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
    
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
              <a class="navbar-brand" href="#">Askforcoupons Blog Dashboard</a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Blogs Data</a>
                </li>
                  
               
            
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
         
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

    <!-- Dashboard Content -->
    <div class="container mt-5" style="max-width:1200px">
        <h3>Admin Blogs Dashboard</h3>

        <!-- Stats Section -->
        <div class="row">
            <div class="col-md-3">
                <div class="card">
                    <div class="card-body">
                        <h5 class="card-title">Total Users</h5>
                        <p class="card-text"><?php echo e($totalUsers); ?></p>
                    </div>
                </div>
            </div>
            <div class="col-md-3">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Total Blogs</h5>
                    <p class="card-text"><?php echo e($total_blogs); ?></p>
                </div>
            </div>
        </div>
        
        </div>

    
    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>

    <!-- Initialize DataTables -->
<script>
    $(document).ready(function() {
     
        $('#usersTable, #votersTable').DataTable({
            "paging": true,
            "ordering": true,
            "info": true,
            "searching": true
        });
    });
</script>
<script>
    $(document).ready(function() {
        
    });
</script>

</body>

</html>
<?php /**PATH /home/u204215099/domains/askforcoupons.com/public_html/blogsAdminDashboard/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>