<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Voter Record</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Edit Voter Record</h3>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('user.update', $data->id)); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>

                            <div class="form-group">
                                <label for="name">Name</label>
                                <input type="text" name="name" class="form-control" value="<?php echo e($data->name); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="father_name">Father's Name</label>
                                <input type="text" name="father_name" class="form-control" value="<?php echo e($data->father_name); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="cnic">CNIC</label>
                                <input type="text" name="cnic" class="form-control" value="<?php echo e($data->cnic); ?>" required>
                            </div>

                                                    <div class="form-group">
                            <label for="polling_station">Polling Station</label>
                            <select name="polling_station" class="form-control" required>
                                <?php $__currentLoopData = $pollingStations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $station): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($station->polling_station_name); ?>" <?php echo e($station->polling_station_name == $data->polling_station_name ? 'selected' : ''); ?>>
                                        <?php echo e($station->polling_station_name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="block_code">Block Code</label>
                            <select name="block_code" class="form-control" required>
                                <?php $__currentLoopData = $blockCodes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $block): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($block->block_code); ?>" <?php echo e($block->block_code == $data->block_code ? 'selected' : ''); ?>>
                                        <?php echo e($block->block_code); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="ward_no">Ward No</label>
                            <select name="ward_no" class="form-control" required>
                                <?php $__currentLoopData = $wards; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($ward->ward_number); ?>" <?php echo e($ward->ward_number == $data->ward_number ? 'selected' : ''); ?>>
                                        <?php echo e($ward->ward_number); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group">
                            <label for="gender">Gender</label>
                            <select name="gender" class="form-control" required>
                                <option value="Male" <?php echo e($data->gender == 'Male' ? 'selected' : ''); ?>>Male</option>
                                <option value="Female" <?php echo e($data->gender == 'Female' ? 'selected' : ''); ?>>Female</option>
                                <!-- Add other gender options if necessary -->
                            </select>
                        </div>
                            

                            <div class="form-group">
                                <label for="gharana_number">Gharana Number</label>
                                <input type="text" name="gharana_number" class="form-control" value="<?php echo e($data->gharana_number); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="address">Address</label>
                                <input type="text" name="address" class="form-control" value="<?php echo e($data->address); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="age">Age</label>
                                <input type="number" name="age" class="form-control" value="<?php echo e($data->age); ?>" required>
                            </div>

                            <div class="form-group">
                                <label for="silsila_number">Silsila Number</label>
                                <input type="text" name="silsila_number" class="form-control" value="<?php echo e($data->silsila_number); ?>" required>
                            </div>

                            <button type="submit" class="btn btn-primary">Update Record</button>
                            <a href="<?php echo e(route('dashboard')); ?>" class="btn btn-secondary">Cancel</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH C:\laragon\www\electionManagemntSystem\resources\views/user/edit-data-form.blade.php ENDPATH**/ ?>