<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\User;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    // Show the login form
    public function showLoginForm()
    {
        return view('auth.login');
    }

    // Handle the login request
    public function login(Request $request)
    {
        // Validate the login credentials
        $validated = $request->validate([
            'email' => 'required|email',
            'password' => 'required|string|min:8',
        ]);

        // Attempt to log the user in
        if (Auth::attempt($validated)) {
            // Check the user's role and redirect accordingly
            if (Auth::user()->role === 'admin') {
                // Redirect to the admin dashboard if the user is an admin
                return redirect()->route('admin.dashboard');
            }

            // Redirect to the user dashboard if the user is a regular user
            return redirect()->route('dashboard');
        }

        // If login fails, redirect back with error messages
        return back()->withErrors([
            'email' => 'The provided credentials do not match our records.',
        ]);
    }


    // Show the sign-up form
    public function showSignUpForm()
    {
        return view('auth.signup');
    }

    // Handle user registration
    public function register(Request $request)
    {
      
        // Validate the registration form data, including new fields
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'email' => 'required|email|max:255|unique:users',
            'password' => 'required|string|min:8|confirmed',
            // 'polling_station' => 'nullable',   // Validating new fields
            // 'block_code' => 'nullable',         // Validating new fields
            // 'ward_no' => 'nullable',            // Validating new fields
            'gender' => 'required',              // Validating new fields
            // 'entry_gender' => 'nullable',
            
        ]);

        // Create the user and store the additional fields in the database
        $user = User::create([
            'name' => $validated['name'],
            'email' => $validated['email'],
            'password' => Hash::make($validated['password']),
            'gender' => $validated['gender'] ,      
            // 'polling_station' => $validated['polling_station'],  
            // 'block_code' => $validated['block_code'] ,           
            // 'ward_no' => $validated['ward_no'] ,                  
            // 'gender' => $validated['gender'] ,      
            // 'entry_gender' => $validated['entry_gender'],      
            'role' => 'user',  // Assign the default 'user' role to new users        
        ]);
     
        // Log the user in immediately after registration (optional)
        Auth::login($user);

        // Redirect to the dashboard or home page
        return redirect()->intended('/dashboard');  // Change this route to your actual dashboard or home page
    }

    // Handle logout
    public function logout()
    {
        Auth::logout();

        // Redirect to the login page after logout
        return redirect()->route('login');
    }

    public function updateDefaultFields(Request $request)
{  

    $request->validate([
        'polling_station' => 'required|exists:polling_stations,polling_station_name',
        'block_code' => 'required|exists:block_codes,block_code',
        'gender' => 'required',
        'ward_no' => 'required|exists:wards,ward_number',
    ]);

    $user=User::find(auth()->user()->id);
  
    $user->polling_station = $request->polling_station;
    $user->block_code = $request->block_code;
    $user->gender = $request->gender;
    $user->ward_no = $request->ward_no;
    $user->save();
    

   return redirect()->route('user.dataForm')->with('success', 'Default fields updated successfully.');
}
}
