<?php

namespace App\Http\Controllers;

use App\Models\PollingStation;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class PollingStationController extends Controller
{
    public function index()
{
    $pollingStations = DB::table('polling_stations')
        ->leftJoin('voters_data', 'polling_station_name', '=', 'voters_data.polling_station') // Adjust the relationship as needed
        ->select(
            'polling_stations.id',
            'polling_stations.polling_station_name', // Or any other column you want from polling_stations
            DB::raw('COUNT(voters_data.id) AS voters_count'),
            DB::raw('SUM(CASE WHEN voters_data.gender = "male" THEN 1 ELSE 0 END) AS males_count'),
            DB::raw('SUM(CASE WHEN voters_data.gender = "female" THEN 1 ELSE 0 END) AS females_count')
        )
        ->groupBy('polling_stations.id', 'polling_stations.polling_station_name') // Adjust grouping based on your table structure
        ->get();
    
    return view('admin.polling_stations.index', compact('pollingStations'));
}


    public function store(Request $request)
    {
        $request->validate([
            'polling_station_name' => 'required|string|max:255',
        ]);

        PollingStation::create([
            'polling_station_name' => $request->polling_station_name,
        ]);

        return redirect()->route('admin.polling_stations.index')->with('success', 'Polling station added successfully!');
    }

    public function destroy(PollingStation $pollingStation)
    {
        $pollingStation->delete();
        return redirect()->route('admin.polling_stations.index')->with('success', 'Polling station deleted successfully!');
    }
}
