<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BlogsData;
use App\Models\PollingStation;
use App\Models\BlockCode;
use App\Models\Ward;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;



class VotersDataController extends Controller
{

    public function getBlogs()
        {
            // $blogs = BlogsData::all();  // Limit to 5 most recent blogs
            $blogs = BlogsData::orderBy('created_at', 'desc')->get();
            return response()->json($blogs);
        }
        public function getSingleBlog($slug)
        {
        // Fetch the blog post by ID
        $blog = BlogsData::where("slug",$slug)->first();

        // If the blog post is not found, return a 404 error
        if (!$blog) {
            return response()->json(['error' => 'Blog not found'], 404);
        }

        // Return the blog post data as JSON
        return response()->json($blog);
    }
    public function index()
{
    // Fetch voter records for the authenticated user
    $blogs_data = BlogsData::all();

    // Pass the data to the view
    return view('dashboard', compact('blogs_data'));
}

public function show($id)
{
    $data = BlogsData::findOrFail($id);
    return response()->json($data);
}

public function view($id)
{
    // Retrieve the voter record by ID
    $voter = BlogsData::findOrFail($id);
    
    // Pass the voter data to the view
    return view('user.view', compact('voter'));
}
public function destroy($id)
{
  
    // Find the record by ID and ensure it's owned by the authenticated user
    $record = BlogsData::where('user_id', Auth::id())->findOrFail($id);
    $record->delete();

    return response()->json(['success' => 'Record deleted successfully']);
}
    public function createDataForm()
{
   
    return view('user.createData', compact('pollingStations', 'blockCodes', 'wards'));
}
    public function showForm()
    {

        $user = auth()->user();
        $pollingStations = PollingStation::all();
        $blockCodes = BlockCode::all();
        $wards = Ward::all();
        
        return view('user.data-form', compact('pollingStations', 'blockCodes', 'wards','user'));
    }
    

    // public function store(Request $request)
    // {
      
    //     $request->validate([
    //         'title' => 'required',
    //         'content' => 'required',
    //         'image' => 'required',
        
    //     ]);

    //     BlogsData::create($request->all());

    //     return redirect()->route('user.dataForm')->with('success', 'Data saved successfully!');
    // }
    
    public function store(Request $request)
{
   
    // Validate the request inputs
    $request->validate([
        'title' => 'required',
        'content' => 'required',
        'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048', // Ensure it's an image and limit size
        'user_id' => 'required',
       
    ]);
        $slug = Str::slug($request->title);
  
    // Handle the image upload
    if ($request->hasFile('image')) {
        // Store the image in a public directory and get the path
        $imagePath = $request->file('image')->store('images', 'public');
    
          // Generate a unique slug from the title
    
        // Create a new blog entry with the image path
        BlogsData::create([
            'title' => $request->title,
            'content' => $request->content,
            'image' => $imagePath, // Save the path in the database
            'user_id' => $request->user_id,
            'slug' => $slug,
          
        ]);

        return redirect()->route('user.dataForm')->with('success', 'Data saved successfully!');
    }

    return redirect()->route('user.dataForm')->with('error', 'Image upload failed!');
}

    public function edit($id)
    {
        $data = BlogsData::findOrFail($id);
        $pollingStations = PollingStation::all();
        $blockCodes = BlockCode::all();
        $wards = Ward::all();
    
        return view('user.edit-data-form', compact('data', 'pollingStations', 'blockCodes', 'wards'));
    }

   public function update(Request $request, $id)
{
    $request->validate([
        'title' => 'required',
        'content' => 'required',
        'image' => 'required|image|mimes:jpeg,png,jpg,gif|max:2048',
    ]);

    $data = BlogsData::findOrFail($id);

    if ($request->hasFile('image')) {
        // Store the image in a public directory and get the path
        $imagePath = $request->file('image')->store('images', 'public');

        // Update the image field explicitly in the data array
        $data->update([
            'title' => $request->title,
            'content' => $request->content,
            'image' => $imagePath,
        ]);
    } else {
        // Update without image if no file was uploaded
        $data->update([
            'title' => $request->title,
            'content' => $request->content,
        ]);
    }

    return redirect()->route('dashboard')->with('success', 'Data updated successfully!');
}



    public function showCnicWithSpaces()
{
    $votersWithSpaces = BlogsData::where('cnic', 'LIKE', '% %')->get();
    return view('admin.cnic_with_spaces', compact('votersWithSpaces'));
}
}
