<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Edit Blog Record</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <!-- Include TinyMCE CDN -->
    <script src="https://cdn.tiny.cloud/1/jm8hj5vtr9jlghx0o9otagozo1ikzupsv46f3bvdb2qqawmc/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <!-- Add Bootstrap's modal and other necessary styles -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
      <script src="https://cdn.ckeditor.com/ckeditor5/29.1.0/classic/ckeditor.js"></script>
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h3>Edit Blog Record</h3>
                          <a href="{{ route('dashboard') }}" class="btn btn-secondary" style="float: right;">Dashboard</a>
                    </div>
                   
                    <div class="card-body">
                        <form action="{{ route('user.update', $data->id) }}" method="POST" enctype="multipart/form-data">
                           @csrf
            @method('PUT')
            @if (session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if (session('error'))
                <div class="alert alert-danger">
                    {{ session('error') }}
                </div>
            @endif


            <div class="form-group">
                <label for="title">Title</label>
                <input type="text" class="form-control" id="title" name="title" value="{{ $data->title }}" required>
            </div>

            <div class="form-group">
                <label for="content">Content</label>
                 <textarea name="content" id="content" class="form-control" style="height: 200px;">{{ $data->content }}</textarea>
            </div>

            <!-- Display the current image as clickable text -->
            <div class="form-group">
                <label for="current_image">Current Image</label>
                @if ($data->image)
                    <div>
                        <!-- Text link to open modal -->
                        <a href="javascript:void(0);" data-toggle="modal" data-target="#imageModal" id="imageLink">Click here to view image</a>
                    </div>
                @else
                    <p>No image available</p>
                @endif
            </div>

            <!-- Image upload input -->
            <div class="form-group">
                <label for="image">Update Image</label>
                <input type="file" class="form-control-file" id="image" name="image">
            </div>

            <button type="submit" class="btn btn-primary">Update Blog</button>
        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
  <!-- Modal to show the image -->
    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="imageModalLabel">View Image</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <img id="modalImage" src="{{ env('IMAGE_URL') . $data->image }}" alt="Current Image" class="img-fluid">
                </div>
            </div>
        </div>
    </div>
    
    <script>
        // Initialize CKEditor
        ClassicEditor
            .create(document.querySelector('#content'))
            .then(editor => {
                window.editor = editor;  // Store editor instance for later use

                // Custom form validation
                editor.model.document.on('change:data', () => {
                    // Check if the editor content is empty and set the custom validity
                    document.getElementById('content').setCustomValidity(editor.getData().trim() === '' ? 'This field cannot be empty' : '');
                });
            })
            .catch(error => {
                console.error(error);
            });
    </script>
    
     <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</html>
