<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AdminDashboardController;
use App\Http\Controllers\PollingStationController;
use App\Http\Controllers\WardController;
use App\Http\Controllers\BlockCodeController;
use App\Http\Controllers\VotersDataController;
use App\Http\Controllers\AppUserController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return view('/auth/login');
});
Route::get('/admin/cnic-with-spaces', [VotersDataController::class, 'showCnicWithSpaces'])->name('admin.cnicWithSpaces');
Route::get('/admin/duplicate-cnic', [AdminDashboardController::class, 'showDuplicateCnic'])->name('admin.duplicateCnic');


Route::get('/login', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/login', [AuthController::class, 'login']);

Route::get('/signup', [AuthController::class, 'showSignUpForm'])->name('signup');
Route::post('/signup', [AuthController::class, 'register'])->name('signup');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');



Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
Route::get('/admin/allblogs', [AdminDashboardController::class, 'voters'])->name('admin.all.voters');

Route::post('/admin/logout', [AdminDashboardController::class, 'logout'])->name('admin.logout');

Route::get('/manage-users', [AdminDashboardController::class, 'manageUsers'])->name('admin.manageUsers');
Route::get('/admin/user/{user_id}/voters', [AdminDashboardController::class, 'showVotersByUser'])->name('userVoters');


Route::prefix('admin')->name('admin.')->group(function () {
    Route::get('/blog/{id}/edit', [AdminDashboardController::class, 'edit'])->name('editVoter'); // Route for showing the edit form
    Route::put('/blog/{id}', [AdminDashboardController::class, 'update'])->name('updateVoter'); // Route for updating the voter entry
    Route::delete('/blog/{id}', [AdminDashboardController::class, 'destroy'])->name('deleteVoter'); // Route for deleting the voter entry
    Route::get('/blog/{id}', [AdminDashboardController::class, 'show'])->name('showVoter'); // View Route
    
    Route::post('blog/create-blog', [AdminDashboardController::class, 'showBlogForm'])->name('showblogform');

    
     
    // Show voters associated with selected user
   
});
 Route::get('admin/user-management', [AppUserController::class, 'userManagement'])->name('userManagement');
    Route::post('admin/user/{id}/change-status', [AppUserController::class, 'changeUserStatus'])->name('changeUserStatus');

// Route to show the Create User form
Route::get('/admin/create-user', [AdminDashboardController::class, 'showCreateUserForm'])->name('admin.createUser');

// Route to handle form submission for creating a user
Route::post('/admin/create-user', [AdminDashboardController::class, 'createUser'])->name('admin.createUser.store');

// Route to show the Edit User form
Route::get('/admin/edit-user/{user}', [AdminDashboardController::class, 'showEditUserForm'])->name('admin.editUser');

// Route to handle form submission for updating the user
Route::put('/admin/edit-user/{user}', [AdminDashboardController::class, 'updateUser'])->name('admin.updateUser');


Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/polling-stations', [PollingStationController::class, 'index'])->name('admin.polling_stations.index');
    Route::post('/admin/polling-stations', [PollingStationController::class, 'store'])->name('admin.polling_stations.store');
    Route::delete('/admin/polling-stations/{pollingStation}', [PollingStationController::class, 'destroy'])->name('admin.polling_stations.destroy');
});


Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/ward', [WardController::class, 'index'])->name('admin.ward.index');
    Route::post('/admin/ward', [WardController::class, 'store'])->name('admin.ward.store');
    Route::delete('/admin/ward/{ward}', [WardController::class, 'destroy'])->name('admin.ward.destroy');
});

Route::middleware(['auth'])->group(function () {
    Route::get('/admin/dashboard', [AdminDashboardController::class, 'index'])->name('admin.dashboard');
    Route::get('/admin/block-code', [BlockCodeController::class, 'index'])->name('admin.block_code.index');
    Route::post('/admin/block-code', [BlockCodeController::class, 'store'])->name('admin.block_code.store');
    Route::delete('/admin/block-code/{block_code}', [BlockCodeController::class, 'destroy'])->name('admin.block_code.destroy');
    Route::get('/voters/block/{block_code}', [AdminDashboardController::class, 'showVotersByBlock'])->name('admin.votersByBlock');
    
  
});

Route::middleware('auth')->group(function () {
    // Show data form
    Route::get('/user/data-form', [VotersDataController::class, 'showForm'])->name('user.dataForm');

    // Store new data
    Route::post('/user/store', [VotersDataController::class, 'store'])->name('user.store');

    // Show edit form
    Route::get('/user/edit/{id}', [VotersDataController::class, 'edit'])->name('user.edit');

    // Update existing data
    Route::put('/user/update/{id}', [VotersDataController::class, 'update'])->name('user.update');

    // Update default fields
    Route::post('/update-default-fields', [AuthController::class, 'updateDefaultFields'])->name('user.updateDefault');

  Route::delete('/user/delete/{id}', [VotersDataController::class, 'destroy'])->name('user.delete');

    Route::get('/user/view/{id}', [VotersDataController::class, 'view'])->name('user.view');
});

Route::post('/admin/updateUser', [AppUserController::class, 'update'])->name('updateUser');
Route::delete('/admin/deleteUser/{id}', [AppUserController::class, 'destroy'])->name('deleteUser');

Route::get('/dashboard', [VotersDataController::class, 'index'])->name('dashboard')->middleware('auth');