<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/jquery.dataTables.min.css">
</head>
<body>
    <div class="container mt-5">
        <div class="row justify-content-center ">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-header">
                        <h3>Welcome, <?php echo e(Auth::user()->name); ?>!</h3> 
                        <a href="<?php echo e(route('user.dataForm')); ?>" class="btn btn-primary mt-3" style="float: right;">Add New Voter Data</a>   
                    </div>
                    
                    <div class="card-body">
                        <p>You're successfully logged in!</p>
                        <p>Below are your voter records:</p>

                        <!-- Table to display voter records -->
                       <table id="voterTable" class="table table-bordered" >
    <thead>
        <tr>
            <th>Name</th>
            <th>Father's Name</th>
            <th>CNIC</th>
            <th>Silsila Number</th>
          
            <th>Actions</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $voters_data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $record): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($record->name); ?></td>
                <td><?php echo e($record->father_name); ?></td>
                <td><?php echo e($record->cnic); ?></td>
                <td><?php echo e($record->silsila_number); ?></td>
                
                <td>
    <div class="d-flex">
        <!-- Edit Button -->
        <a href="<?php echo e(route('user.edit', $record->id)); ?>" class="btn btn-warning btn-sm mr-1">Edit</a>
        
        <!-- View Button -->
        <a href="<?php echo e(route('user.view', $record->id)); ?>" class="btn btn-info btn-sm mr-1">View</a>
        
        <!-- Delete Button -->
        <button class="btn btn-danger btn-sm deleteRecord" data-id="<?php echo e($record->id); ?>">Delete</button>
    </div>
</td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

                        <!-- Logout Button -->
                        <div class="text-right mt-4">
                            <form action="<?php echo e(route('logout')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <button type="submit" class="btn btn-danger">Logout</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Scripts -->
    <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.12.1/js/jquery.dataTables.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/2.1.2/sweetalert.min.js"></script>

    <script>
        $(document).ready(function() {
            // Initialize DataTable
            $('#voterTable').DataTable();

            // Delete record functionality
            $('.deleteRecord').on('click', function() {
                var recordId = $(this).data('id');
                
                // Confirm with SweetAlert
                swal({
                    title: "Are you sure?",
                    text: "Once deleted, you cannot recover this record!",
                    icon: "warning",
                    buttons: true,
                    dangerMode: true,
                })
                .then((willDelete) => {
                    if (willDelete) {
                        $.ajax({
                            url: '/user/delete/' + recordId,
                            type: 'DELETE',
                            data: {
                                _token: '<?php echo e(csrf_token()); ?>'
                            },
                            success: function(response) {
                                swal("Poof! Your record has been deleted!", {
                                    icon: "success",
                                }).then(() => {
                                    location.reload();
                                });
                            },
                            error: function() {
                                swal("Something went wrong!", {
                                    icon: "error",
                                });
                            }
                        });
                    }
                });
            });
        });
    </script>
</body>
</html>
<?php /**PATH C:\laragon\www\electionManagemntSystem\resources\views/dashboard.blade.php ENDPATH**/ ?>