<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Dashboard</title>
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/jquery.dataTables.min.css">
</head>
<body>

  <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <a class="navbar-brand" href="#"></a>
        <button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ml-auto">
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">Dashboard</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.all.voters')); ?>">All Voters Data</a>
                </li>
                 <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('userManagement')); ?>">Mobile Users</a>
                </li>
                
                <li class="nav-item">
                 
                    <a class="nav-link" href="<?php echo e(route('admin.manageUsers')); ?>">Manage Users</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.cnicWithSpaces')); ?>">CNICs with Spaces</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.duplicateCnic')); ?>">Duplicate CNIC Records</a>
                </li>
                <li class="nav-item">
                <a class="nav-link" href="<?php echo e(route('admin.createUser')); ?>">Create User</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.polling_stations.index')); ?>">Manage Polling Stations</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.block_code.index')); ?>">Manage Block Codes</a>
                </li>
                <li class="nav-item">
                    <a class="nav-link" href="<?php echo e(route('admin.ward.index')); ?>">Manage Ward Number</a>
                </li>
                
                <li class="nav-item">
                <form action="<?php echo e(route('admin.logout')); ?>" method="POST" style="display: inline;">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="nav-link btn btn-link" style="color: white;">Logout</button>
                </form>
            </li>
            </ul>
        </div>
    </nav>

<div class="container mt-5">
    <h3>Manage Ward Number </h3>

    <!-- Add Ward Number Form -->
    <form action="<?php echo e(route('admin.ward.store')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <div class="form-group">
            <label for="ward">Ward Number</label>
            <input type="text" name="ward_number" class="form-control" required>
        </div>
        <button type="submit" class="btn btn-primary">Add Ward Number</button>
    </form>
<br>
    <!-- Ward Numbers List -->
    <table class="table table-bordered mt-4" id="wardsTable">
        <thead>
            <tr>
                <th>#</th>
                <th>Ward Number Name</th>
                <th>Male Count</th>
                <th>Female Count</th>
                <th>Voter Count</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $ward; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ward): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                     <td><?php echo e($loop->iteration); ?></td>
                    <td><?php echo e($ward->ward_number); ?></td>
                    <td><?php echo e($ward->males_count); ?></td>
                    <td><?php echo e($ward->females_count); ?></td>    
                    <td><?php echo e($ward->voters_count); ?></td> <!-- Display the voter count -->
                   
                    <td>
                        <form action="<?php echo e(route('admin.ward.destroy', $ward->id)); ?>" method="POST" style="display:inline;">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.5.3/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>

    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script>
    $(document).ready(function() {
        $('#wardsTable').DataTable({
            "paging": true,
            "ordering": true,
            "info": true,
            "searching": true
        });
    });
</script><?php /**PATH /home/u217315747/domains/kaganenterprise.com/public_html/election/resources/views/admin/ward/index.blade.php ENDPATH**/ ?>